<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slider extends Model 
{

    protected $table = 'sliders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasOne('App\User');
    }

    public function category()
    {
        return $this->hasOne('App\Model\SliderCategory', 'id', 'category_id');
    }

}